/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.init;

import com.finallion.graveyard.biomes.HauntedForestBiomes;
import com.finallion.graveyard.config.GraveyardConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="graveyard", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TGBiomes {
    public static List<Biome> BIOMES = new ArrayList<Biome>();
    public static Biome HAUNTED_FOREST = TGBiomes.createBiome("haunted_forest", HauntedForestBiomes.HauntedForestBiome());
    public static Biome HAUNTED_LAKES = TGBiomes.createBiome("haunted_lakes", HauntedForestBiomes.HauntedForestLakeBiome());
    public static Biome ERODED_HAUNTED_FOREST = TGBiomes.createBiome("eroded_haunted_forest", HauntedForestBiomes.ErodedHauntedForestBiome());

    public static Biome createBiome(String id, Biome biome) {
        ResourceLocation resourceLocation = new ResourceLocation("graveyard", id);
        biome.setRegistryName(resourceLocation);
        BIOMES.add(biome);
        return biome;
    }

    public static void addToDictionaries() {
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)HAUNTED_FOREST.getRegistryName()), (int)GraveyardConfig.HAUNTED_FOREST.weight()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)HAUNTED_LAKES.getRegistryName()), (int)GraveyardConfig.HAUNTED_LAKES.weight()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)ERODED_HAUNTED_FOREST.getRegistryName()), (int)GraveyardConfig.ERODED_HAUNTED_FOREST.weight()));
        BIOMES.forEach(biome -> BiomeDictionary.addTypes((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SPOOKY}));
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        TGBiomes.addToDictionaries();
        BIOMES.forEach(biome -> event.getRegistry().register((IForgeRegistryEntry)biome));
    }
}

